//
//  Geeklet.h
//  GeekTool 3
//
//  Created by Yann Bizeul on 19/09/04.
//  Copyright 2004 Tynsoe.org. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GeekletWindow.h"
#import "../../GeekTool Helper/GTPluginsController.h"
#import "GeekletUserDefaults.h"
#import "GTRelativePositionView.h"

#define kGeekletWindowLevel (kCGDesktopWindowLevel+15)
#define kSelectedGeekletWindowLevel (kCGDesktopWindowLevel+20)
#define kKeepOnTopGeekletWindowLevel (NSStatusWindowLevel)
@interface Geeklet : NSObject <NSWindowDelegate> {
//	IBOutlet GeekletWindow *window;
//	IBOutlet NSView *settingsView;
	BOOL selected;
	BOOL gt_movable;
	BOOL visible;
	NSWindowController *windowController;
	NSString *UUID;
}
@property (strong, readonly) IBOutlet GeekletWindow *window;
@property (strong, readonly) IBOutlet NSView *settingsView;

@property (readonly) NSRect quartzFrame;
@property int visible;
@property BOOL selected;
@property BOOL gt_movable;
@property (readonly) NSString *geekletIdentifier;
@property (readonly) NSString *UUID;
@property (copy) NSString *name;

@property BOOL keepOnTop;
//@property BOOL ignoreExpose;
@property BOOL hasShadow;
@property BOOL pinToSpace;
@property NSUInteger relativePosition;
//@property NSPoint centerScreenPoint;
@property NSUInteger displayID;
@property (readonly) BOOL isDisplayPresent;
@property (readonly) NSRect screenFrame;
@property NSRect previousScreenFrame;
@property (readonly) BOOL shouldOpenGeeklet;
@property (unsafe_unretained, readonly) NSUndoManager *undoManager;

+ (NSString*)makeUUID;

+ (NSString*)geekletIdentifier;
+ (NSString*)name;
+ (NSImage*)icon;
+ (NSRect)userRectToQuartzRect:(NSRect)aRect relativePosition:(GTRelativePosition)relativePosition toFrame:(NSRect)screenFrame;
+ (NSRect)quartzRectToUserRect:(NSRect)aRect relativePosition:(GTRelativePosition)relativePosition toFrame:(NSRect)screenFrame;
+ (BOOL)geekletIsOnScreen:(NSRect)aRect;
+ (NSImage*)defaultImage;

+ (NSArray*)pluginUUIDs:(NSString*)anIdentifier;
+ (NSImage*)inspectorIcon;

- (NSRect)userFrame;
- (void)setUserFrame:(NSRect)aFrame sender:(id)sender;
- (void)rebasePosition;
- (int)userVisible;
- (NSImage*)inspectorIcon;
- (BOOL)isOpen;
- (void)open;
- (void)openGeeklet;
- (void)placeBelow:(Geeklet*)aGeeklet;
- (void)close;
- (NSArray*)groups;
- (GeekletUserDefaults*)userDefaults;
- (void)refresh;
- (BOOL)createSettingsFileToURL:(NSURL*)anURL;
//- (NSString*)createSettingsFile;
- (BOOL)shouldAcceptImportedGeeklet;
- (void)setFrameForCurrentScreenConfiguration;
- (BOOL)settingsViewShouldUnload;
@end

@interface Geeklet (Informal)
- (void)geekletDidLoad;
- (void)geekletWillUnload;
- (void)settingsViewWillLoad;
- (void)settingsViewWillUnload;
- (void)settingsViewDidLoad;
@end
